<?php
include 'db.php';
include 'config.php';

$shiping_cost = 0;
$clearance_cost = 0;
$total_cost = 0;


if (isset($_GET['tnum']) &&  $_GET['tnum'] != "") {
  $trackId = $_GET['tnum'];
  $sql = mysqli_query($link, "SELECT * FROM tracking WHERE tracking_number = '$trackId' ");
  if (mysqli_num_rows($sql) > 0) {
    $row = mysqli_fetch_assoc($sql);
    $senders_name = $row['sender_name'];
    $senders_contact = $row['sender_contact'];
    $senders_mail = $row['sender_email'];
    $senders_address = $row['sender_address'];
    $receivers_name = $row['receiver_name'];
    $receivers_contact = $row['receiver_contact'];
    $receivers_mail = $row['receiver_email'];
    $receivers_address = $row['receiver_address'];
    $statuss = $row['status'];
    $dispatch_l = $row['dispatch_location'];
    $dispatchh = $row['dispatch_date'];
    $deliveryy = $row['delivery_date'];
    $location = $row['current_location'];
    $desc = $row['pdesc'];
    $carrier = $row['carrier'];
    $carrier_ref = $row['carrier_ref'];
    $weight = $row['weight'];
    $payment_mode = $row['payment_mode'];
    $ship_mode = $row['ship_mode'];
    $quantity = $row['quantity'];
    $delivery_time = $row['delivery_time'];
    $image = $row['image'];
    $destination = $row['destination'];
    $date = $row['date'];

    $barcode_url = "https://barcode.tec-it.com/barcode.ashx?data=" . urlencode($trackId) . "&code=Code128";
  }

  $sqls = mysqli_query($link, "SELECT * FROM track_update  WHERE track_num = '$trackId' ORDER BY track_num DESC LIMIT 1  ");
  if (mysqli_num_rows($sqls) > 0) {
    $rows = mysqli_fetch_assoc($sqls);
    $status = $rows['status'] ?? "";
    $current_location = $rows['current_location'] ?? "";
    $shiping_cost  = $rows['shiping_cost'] ?? 0;
    $clearance_cost = $rows['clearance_cost'] ?? 0;
    $total_cost = $clearance_cost + $shiping_cost;
  }else{
    $status =  "";
    $current_location = "";
    $shiping_cost  =  0;
    $clearance_cost = 0;
    $total_cost = $clearance_cost + $shiping_cost;
  }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title> <?php echo $sitename ?> Shipment Invoice</title>
</head>
<style>
    body {
  font-family: 'Segoe UI', sans-serif;
  background: #f9f9f9;
  color: #333;
  margin: 0;
  padding: 20px;
}

.container {
  max-width: 900px;
  margin: auto;
  background: #fff;
  padding: 25px;
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  border-bottom: 2px solid #ff6600;
  padding-bottom: 10px;
  margin-bottom: 20px;
}

.logo {
  font-size: 24px;
  font-weight: bold;
  color: #ff6600;
}

.tracking .highlight {
  color: #cc0000;
  font-size: 18px;
}

.company-info {
  margin-bottom: 20px;
  font-size: 15px;
  color: #006600;
}

.shipment-details {
  display: flex;
  justify-content: space-between;
  margin-bottom: 20px;
  flex-wrap: wrap;
}

.shipment-details div {
  flex: 1;
  margin: 10px;
}

.barcode img {
  max-height: 80px;
}

.shipment-table {
  width: 100%;
  border-collapse: collapse;
  margin-bottom: 25px;
}

.shipment-table th, .shipment-table td {
  border: 1px solid #ccc;
  padding: 10px;
  text-align: center;
}

.status.active {
  background-color: #4caf50;
  color: white;
  padding: 3px 8px;
  border-radius: 5px;
}

.payment {
  margin: 20px 0;
}

.payment img {
  height: 40px;
}

.footer-stamps {
  display: flex;
  justify-content: space-between;
  margin-top: 30px;
  gap: 20px;
  flex-wrap: wrap;
}

.footer-stamps div {
  flex: 1;
  text-align: center;
}

</style>
<body  onload="window.print();">
  <div class="container">
    <header>
      <div class="logo"><img src="assets/img/logo.png" width="300" height="80" alt=""></div>
      <div class="tracking">
        <strong>Tracking Number:</strong> <span class="highlight"><?php echo $trackId ?></span>
      </div>
    </header>

    <section class="company-info">
      <p><strong>Website:</strong> <a href="#"><?=$site_url?></a></p>
      <p><strong>Email:</strong> <?=$email_address?></p>
    </section>

    <section class="shipment-details">
      <div class="from">
        <h3>From (Sender)</h3>
        <p><strong>Name:</strong> <?=$senders_name?></p>
        <p><strong>Phone:</strong> <?=$senders_contact?></p>
        <p><strong>Address:</strong> <?=$senders_address?></p>
      </div>
      <div class="to">
        <h3>To (Receiver)</h3>
        <p><strong>Name:</strong> <?=$receivers_name?></p>
        <p><strong>Phone:</strong> <?=$receivers_contact?></p>
        <p><strong>Address:</strong> <?=$receivers_address?></p>
      </div>
      <div class="barcode">
        <img src="<?php echo $barcode_url ?>" alt="Barcode">
      </div>
    </section>

    <table class="shipment-table">
      <thead>
        <tr>
          <th>Qty</th>
          <th>Location</th>
          <th>Status</th>
          <th>Description</th>
          <th>Shipping</th>
          <th>Clearance</th>
          <th>Total</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td><?php echo $quantity ?></td>
          <td><?=$current_location?></td>
          <td><span class="status active"><?=$status?></span></td>
          <td><?php echo $desc ?></td>
          <td>$<?php echo number_format($shiping_cost, 2) ?></td>
          <td>$<?php echo number_format($clearance_cost, 2) ?></td>
          <td>$<?php echo number_format($total_cost, 2) ?></td>
        </tr>
      </tbody>
    </table>

    <section class="payment">
      <h3>Payment Methods:</h3>
      <img src="assets/img/securepayment.png" alt="Payment Logos" />
    </section>

    <section class="footer-stamps">
      <div>
        <h4>Official Stamp</h4>
        <p>Date: <?php echo $date ?></p>
        <img src="assets/img/stamp1.png" alt="Official Stamp" width="100"/>
      </div>
      <div>
        <h4>Stamp Duty</h4>
        <img src="assets/img/stamp2.png" alt="Stamp Duty" width="100"/>
      </div>
      <div class="amount">
        <h4>Amount Due</h4>
        <p><strong>Shipping:</strong> $<?=$shiping_cost?></p>
        <p><strong>Clearance:</strong> $<?=$clearance_cost?></p>
        <p><strong>Total:</strong> $<?=$total_cost?></p>
      </div>
    </section>
  </div>
  <center><a href="index.php">Back Home</a> </center>
</body>
</html>
