<?php
include "header.php";

?>
    <!-- Tracking Hero Section -->
    <div class="tracking-hero pt-5">
        <div class="container text-center">
            <br> <br>
            <h1 class="tracking-title fade-in-up py-5">Track Your Shipment</h1>
            <p class="tracking-subtitle fade-in-up" style="animation-delay: 0.1s;">Get real-time updates on your package's journey from origin to destination.</p>
            
            <div class="search-container fade-in-up" style="animation-delay: 0.2s;">
                <form method="POST" action="tracks.php" class="d-flex">
                    <input type="text" class="form-control search-input" id="trackingID" name="tracking_number" placeholder="Enter your tracking number" value="" required>
                    <button class="btn search-button" name="submit" type="submit">
                        <i class="fas fa-search me-2"></i> 
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Results Section -->
   

    <!-- Animation Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Handle loading animation
            const loader = document.getElementById('loadingAnimation');
            
            setTimeout(function() {
                loader.classList.add('fade-out');
                setTimeout(function() {
                    loader.style.display = 'none';
                }, 500);
            }, 1200);
            
            // Show loading animation when form is submitted
            const trackingForm = document.querySelector('form');
            if (trackingForm) {
                trackingForm.addEventListener('submit', function() {
                    loader.classList.remove('fade-out');
                    loader.style.display = 'flex';
                });
            }
            
                        // Show error notification for not found
            // showNotification({
            //     type: 'error',
            //     title: 'Tracking Number Not Found',
            //     message: 'Please check your tracking number and try again.'
            // });
                        
                        
            // Custom notification function
            function showNotification(options) {
                const notificationElement = document.createElement('div');
                notificationElement.className = 'custom-notification';
                notificationElement.innerHTML = `
                    <div class="notification-${options.type}">
                        <div class="notification-icon">
                            <i class="fas fa-${options.type === 'error' ? 'exclamation-circle' : 'info-circle'}"></i>
                        </div>
                        <div class="notification-content">
                            <h4>${options.title}</h4>
                            <p>${options.message}</p>
                        </div>
                        <button type="button" class="notification-close">×</button>
                    </div>
                `;
                
                document.body.appendChild(notificationElement);
                
                // Handle close button
                const closeButton = notificationElement.querySelector('.notification-close');
                closeButton.addEventListener('click', function() {
                    notificationElement.style.animation = 'fadeOutNotification 0.3s forwards';
                    setTimeout(function() {
                        notificationElement.remove();
                    }, 300);
                });
                
                // Auto-remove after 7 seconds
                setTimeout(function() {
                    if (document.body.contains(notificationElement)) {
                        notificationElement.remove();
                    }
                }, 7000);
            }
        });
    </script>

<?php
include "footer.php";
?>