<?php
include 'header.php';

$track_num = '';
$error = '';

// Check if a tracking number is provided via POST
if (isset($_GET['tracking_number']) && !empty($_GET['tracking_number'])) {
    $track_num = text_input($_GET['tracking_number']);
    $sql = mysqli_query($link, "SELECT * FROM tracking WHERE tracking_number = '$track_num'");
    if(mysqli_num_rows($sql) > 0){
        $row = mysqli_fetch_assoc($sql);
        $track_number = $row['tracking_number'];
        $sendersname = $row['sender_name'];
        $current_location = $row['current_location'];
        $senderscontact = $row['sender_contact'];
        $sendersmail = $row['sender_email'];
        $sendersaddress = $row['sender_address'];
        $receiversname = $row['receiver_name'];
        $receiverscontact = $row['receiver_contact'];
        $receiversmail = $row['receiver_email'];
        $status = $row['status'];
        $dispatchl = $row['dispatchl'];
        $dispatch = $row['dispatch'];
        $delivery = $row['delivery'];
        $desc = $row['desc'];
        $carrier = $row['carrier'];
        $carrier_ref = $row['carrier_ref'];
        $weight = $row['weight'];
        $payment_mode = $row['payment_mode'];
        $ship_mode = $row['ship_mode'];
        $quantity = $row['quantity'];
        $destination = $row['destination'];
        $delivery_time = $row['delivery_time'];
        $dest = $row['dest'];

        
    } else {
        $error = "Invalid tracking ID. Please input a valid tracking ID.";
    }
} else {
    if (isset($_GET['submit']) && empty($_GET['tracking_number'])) {
        $error = "Please input your tracking ID.";
       header('location: tracking.php?tracking_number=' . urlencode($track_num));
    }
}

?>


    <!-- Tracking Hero Section -->
    <div class="tracking-hero pt-5">
        <div class="container text-center">
            <br> <br>
            <h1 class="tracking-title fade-in-up py-5">Track Your Shipment</h1>
            <p class="tracking-subtitle fade-in-up" style="animation-delay: 0.1s;">Get real-time updates on your package's journey from origin to destination.</p>
            <?php if (!empty($error)) { ?>
                <p style="color: red;"><?php echo $error; ?></p>
            <?php } ?>
            <div class="search-container fade-in-up" style="animation-delay: 0.2s;">
                <form method="GET" action="" class="d-flex">
                    <input type="text" class="form-control search-input" id="trackingID" name="tracking_number" placeholder="Enter your tracking number" value="" required>
                    <button class="btn search-button" name="submit" type="submit">
                        <i class="fas fa-search me-2"></i> 
                    </button>
                </form>
            </div>
        </div>
    </div>
    <?php if (!empty($track_num) && empty($error)) { ?>
    <!-- Results Section -->
    <section class="py-5">
        <div class="container">
            
                            <div class="tracking-card fade-in-up">
                    <div class="tracking-card-header">
                        <h2 class="m-0">Tracking Information</h2>
                    </div>
                    <div class="tracking-card-body">
                        <!-- Progress Tracker -->
                        <div class="progress-tracker">
                            <div class="progress-bar-container">
                                <div class="progress-bar-fill" style="--progress-percent: 60%;"></div>
                            </div>
                            <div class="progress-steps">
                                                                <div class="step-item completed fade-in-up" style="animation-delay: 0.3s;" data-value="0">
                                    <div class="step-icon">
                                        <i class="fas fa-warehouse"></i>
                                    </div>
                                    <div class="step-label">Arrival</div>
                                </div>
                                                                <div class="step-item completed fade-in-up" style="animation-delay: 0.4s;" data-value="20">
                                    <div class="step-icon">
                                        <i class="fas fa-plane-departure"></i>
                                    </div>
                                    <div class="step-label">Departure</div>
                                </div>
                                                                <div class="step-item completed fade-in-up" style="animation-delay: 0.5s;" data-value="40">
                                    <div class="step-icon">
                                        <i class="fas fa-truck-moving"></i>
                                    </div>
                                    <div class="step-label">InTransit</div>
                                </div>
                                                                <div class="step-item completed fade-in-up" style="animation-delay: 0.6s;" data-value="60">
                                    <div class="step-icon">
                                        <i class="fas fa-clipboard-check"></i>
                                    </div>
                                    <div class="step-label">Custom clearance</div>
                                </div>
                                                                <div class="step-item  fade-in-up" style="animation-delay: 0.7s;" data-value="80">
                                    <div class="step-icon">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </div>
                                    <div class="step-label">Destination</div>
                                </div>
                                                                <div class="step-item  fade-in-up" style="animation-delay: 0.8s;" data-value="100">
                                    <div class="step-icon">
                                        <i class="fas fa-box-open"></i>
                                    </div>
                                    <div class="step-label">Delivered</div>
                                </div>
                                                            </div>
                        </div>

                        <!-- Parcel Details -->
                        <div class="parcel-details">
                            <div class="detail-item fade-in-up" style="animation-delay: 0.4s;">
                                <div class="detail-label"><i class="fas fa-map-marker-alt"></i> Origin</div>
                                <div class="detail-value"><?php echo $current_location; ?></div>
                            </div>
                            <div class="detail-item fade-in-up" style="animation-delay: 0.5s;">
                                <div class="detail-label"><i class="fas fa-map-pin"></i> Destination</div>
                                <div class="detail-value"><?php echo $destination; ?></div>
                            </div>
                            <div class="detail-item fade-in-up" style="animation-delay: 0.6s;">
                                <div class="detail-label"><i class="fas fa-shipping-fast"></i> Shipment Type</div>
                                <div class="detail-value"><?php echo $ship_mode; ?></div>
                            </div>
                            <div class="detail-item fade-in-up" style="animation-delay: 0.7s;">
                                <div class="detail-label"><i class="far fa-calendar-alt"></i> Expected Delivery</div>
                                <div class="detail-value"><?php echo $delivery_time; ?></div>
                            </div>
                        </div>

                        <!-- Timeline -->
                        <div class="timeline-container">
                            <div class="timeline-connector"></div>
                                                        <div class="timeline-item " style="animation-delay: 0.2s;" data-animation-index="0">
                                <div class="timeline-dot"></div>
                                <div class="timeline-content">
                                    <div class="timeline-date">
                                        <i class="far fa-clock"></i>
                                        <?php echo $delivery_time; ?>                                   </div>
                                    <h4 class="timeline-title">
                                        Arrived at Warehouse                                    </h4>
                                    <p class="timeline-text">
                                        Package has arrived at the warehouse.                                    </p>
                                </div>
                            </div>
                                                        <div class="timeline-item " style="animation-delay: 0.35s;" data-animation-index="1">
                                <div class="timeline-dot"></div>
                                <div class="timeline-content">
                                    <div class="timeline-date">
                                        <i class="far fa-clock"></i>
                                        2025-03-17 15:41:27                                    </div>
                                    <h4 class="timeline-title">
                                        Departure                                    </h4>
                                    <p class="timeline-text">
                                        Package has left the warehouse.                                    </p>
                                </div>
                            </div>
                                                        <div class="timeline-item " style="animation-delay: 0.5s;" data-animation-index="2">
                                <div class="timeline-dot"></div>
                                <div class="timeline-content">
                                    <div class="timeline-date">
                                        <i class="far fa-clock"></i>
                                        2025-03-18 15:41:27                                    </div>
                                    <h4 class="timeline-title">
                                        In Transit                                    </h4>
                                    <p class="timeline-text">
                                        Package on the way.                                    </p>
                                </div>
                            </div>
                                                        <div class="timeline-item active" style="animation-delay: 0.65s;" data-animation-index="3">
                                <div class="timeline-dot"></div>
                                <div class="timeline-content">
                                    <div class="timeline-date">
                                        <i class="far fa-clock"></i>
                                        2025-03-19 10:01:45                                    </div>
                                    <h4 class="timeline-title">
                                        Custom Clearance                                    </h4>
                                    <p class="timeline-text">
                                        Package at the custom clearance point.                                    </p>
                                </div>
                            </div>
                                                        <div class="timeline-item " style="animation-delay: 0.8s;" data-animation-index="4">
                                <div class="timeline-dot"></div>
                                <div class="timeline-content">
                                    <div class="timeline-date">
                                        <i class="far fa-clock"></i>
                                        2025-03-20 10:01:45                                    </div>
                                    <h4 class="timeline-title">
                                        Destination                                    </h4>
                                    <p class="timeline-text">
                                        Package arrived at the destination.                                    </p>
                                </div>
                            </div>
                                                        <div class="timeline-item " style="animation-delay: 0.95s;" data-animation-index="5">
                                <div class="timeline-dot"></div>
                                <div class="timeline-content">
                                    <div class="timeline-date">
                                        <i class="far fa-clock"></i>
                                        2025-03-21 14:22:12                                    </div>
                                    <h4 class="timeline-title">
                                        Out for Delivery                                    </h4>
                                    <p class="timeline-text">
                                        Package out for delivery.                                    </p>
                                </div>
                            </div>
                                                    </div>

                        <!-- Accordion for Map and Images -->
                        <div class="accordion mt-5" id="trackingAccordion">
                                                        <div class="accordion-item border-0 mb-3 fade-in-up" style="animation-delay: 0.8s;">
                                <h2 class="accordion-header" id="headingMap">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseMap" aria-expanded="false" aria-controls="collapseMap">
                                        <i class="fas fa-map-marked-alt me-2"></i> View Package Location
                                    </button>
                                </h2>
                                <div id="collapseMap" class="accordion-collapse collapse" aria-labelledby="headingMap" data-bs-parent="#trackingAccordion">
                                    <div class="accordion-body p-0">
                                        <iframe src="https://www.google.com/maps/embed?pb=!1m28!1m12!1m3!1d3151638.364666187!2d-83.47711311699956!3d39.51963890568109!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!4m13!3e0!4m5!1s0x88400ce51a8279d5%3A0xeab7faf94532a112!2sE%20Wadsworth%20St%2C%20Eaton%2C%20OH%2045320%2C%20USA!3m2!1d39.742584!2d-84.6355049!4m5!1s0x89b7c6de5af6e45b%3A0xc2524522d4885d2a!2sWashington%20D.C.%2C%20DC%2C%20USA!3m2!1d38.9071923!2d-77.0368707!5e0!3m2!1sen!2sng!4v1742682374255!5m2!1sen!2sng" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                    </div>
                                </div>
                            </div>
                            
                                                        <div class="accordion-item border-0 fade-in-up" style="animation-delay: 0.9s;">
                                <h2 class="accordion-header" id="headingImages">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseImages" aria-expanded="false" aria-controls="collapseImages">
                                        <i class="fas fa-images me-2"></i> View Package Images
                                    </button>
                                </h2>
                                <div id="collapseImages" class="accordion-collapse collapse" aria-labelledby="headingImages" data-bs-parent="#trackingAccordion">
                                    <div class="accordion-body">
                                        <div class="parcel-images">
                                            <div class="parcel-image fade-in-up" style="animation-delay: 0.5s;"><img src="https://admin.cargotransitltd.com/uploads/2025/03/img_67dc4cd8e673a7.00599599.jpeg" alt="Parcel Image" loading="lazy" onerror="this.src='assets/img/placeholder-image.jpg'" /></div>                                        </div>
                                    </div>
                                </div>
                            </div>
                                                    </div>
                    </div>
                </div>
                
                <!-- Delivery Status Badge -->
                <div class="delivery-status-badge fade-in-up" style="animation-delay: 1s; text-align: center; margin-bottom: 30px;">
                                        <h4 class="mb-0 text-warning">
                        <i class="fas fa-clipboard-check me-2"></i> 
                        Current Status: <strong>In Customs</strong>
                    </h4>
                </div>
                    </div>
    </section>

    <!-- Animation Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Handle loading animation
            const loader = document.getElementById('loadingAnimation');
            
            setTimeout(function() {
                loader.classList.add('fade-out');
                setTimeout(function() {
                    loader.style.display = 'none';
                }, 500);
            }, 1200);
            
            // Show loading animation when form is submitted
            const trackingForm = document.querySelector('form');
            if (trackingForm) {
                trackingForm.addEventListener('submit', function() {
                    loader.classList.remove('fade-out');
                    loader.style.display = 'flex';
                });
            }
            
                        
                        // Show welcome notification
            showNotification({
                type: 'info',
                title: 'Tracking Information',
                message: 'We\'ve located your package! View its current status below.'
            });
            
            // Animate progress bar
            setTimeout(function() {
                const progressBar = document.querySelector('.progress-bar-fill');
                if (progressBar) {
                    progressBar.style.width = '60%';
                }
            }, 500);
            
            // Animate timeline items
            setTimeout(function() {
                document.querySelectorAll('.timeline-item').forEach(function(item, index) {
                    setTimeout(function() {
                        item.classList.add('animate');
                    }, index * 200);
                });
            }, 1000);
                        
            // Custom notification function
            function showNotification(options) {
                const notificationElement = document.createElement('div');
                notificationElement.className = 'custom-notification';
                notificationElement.innerHTML = `
                    <div class="notification-${options.type}">
                        <div class="notification-icon">
                            <i class="fas fa-${options.type === 'error' ? 'exclamation-circle' : 'info-circle'}"></i>
                        </div>
                        <div class="notification-content">
                            <h4>${options.title}</h4>
                            <p>${options.message}</p>
                        </div>
                        <button type="button" class="notification-close">×</button>
                    </div>
                `;
                
                document.body.appendChild(notificationElement);
                
                // Handle close button
                const closeButton = notificationElement.querySelector('.notification-close');
                closeButton.addEventListener('click', function() {
                    notificationElement.style.animation = 'fadeOutNotification 0.3s forwards';
                    setTimeout(function() {
                        notificationElement.remove();
                    }, 300);
                });
                
                // Auto-remove after 7 seconds
                setTimeout(function() {
                    if (document.body.contains(notificationElement)) {
                        notificationElement.remove();
                    }
                }, 7000);
            }
        });
    </script>
    
    <?php } ?>
<?php
include 'footer.php';
?>